/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.inventory.operator.client;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.client.ClientOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import dev.terminalmc.clientsort.client.util.SoundManager;
import java.util.ArrayDeque;
import java.util.BitSet;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ClientSurvivalOperator<T extends Operation>
extends ClientOperator<Operation> {
    public ClientSurvivalOperator(AbstractContainerScreen<?> screen, ContainerScreenHelper<? extends AbstractContainerScreen<?>> screenHelper, Slot originSlot, T operation) {
        super(screen, screenHelper, originSlot, operation);
    }

    @Override
    protected void collect() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation COLLECT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation COLLECT", new Object[0]);
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            Slot srcSlot = this.originScopeSlots[i];
            ItemStack srcStack = this.originScopeStacks[i];
            if (srcStack.isEmpty() || srcStack.getCount() >= srcSlot.getMaxStackSize(srcStack)) continue;
            clickEvents.add(this.screenHelper.createClickEvent(srcSlot, 0, ClickType.PICKUP, false));
            for (int j = 0; j < i; ++j) {
                Slot dstSlot = this.originScopeSlots[j];
                ItemStack dstStack = this.originScopeStacks[j];
                if (dstStack.isEmpty() || dstStack.getCount() >= dstSlot.getMaxStackSize(dstStack) || !ItemStack.isSameItemSameComponents((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                int delta = dstSlot.getMaxStackSize(dstStack) - dstStack.getCount();
                delta = Math.min(delta, srcStack.getCount());
                srcStack.shrink(delta);
                dstStack.grow(delta);
                clickEvents.add(this.screenHelper.createClickEvent(dstSlot, 0, ClickType.PICKUP, false));
                if (srcStack.getCount() <= 0) break;
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.getCount() > 0) {
                    InteractionManager.push(this.screenHelper.createClickEvent(srcSlot, 0, ClickType.PICKUP, false));
                } else {
                    this.originScopeStacks[i] = ItemStack.EMPTY;
                }
            }
            clickEvents.clear();
        }
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation COLLECT", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void sort(int[] sortedIds, boolean playSound) {
        int i;
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation SORT: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation SORT", new Object[0]);
        }
        int slotCount = this.originScopeStacks.length;
        int[] srcToDst = new int[slotCount];
        for (int i2 = 0; i2 < slotCount; ++i2) {
            srcToDst[sortedIds[i2]] = i2;
        }
        BitSet done = new BitSet(slotCount);
        BitSet empty = new BitSet(slotCount);
        for (i = 0; i < slotCount; ++i) {
            if (i == sortedIds[i]) {
                done.set(i);
            }
            if (!this.originScopeStacks[i].isEmpty()) continue;
            empty.set(i);
        }
        block2: for (i = 0; i < slotCount; ++i) {
            if (done.get(i)) continue;
            if (empty.get(sortedIds[i])) {
                done.set(sortedIds[i]);
                continue;
            }
            InteractionManager.push(this.screenHelper.createClickEvent(this.originScopeSlots[sortedIds[i]], 0, ClickType.PICKUP, playSound));
            ItemStack carriedStack = this.originScopeStacks[sortedIds[i]];
            this.originScopeStacks[sortedIds[i]] = ItemStack.EMPTY;
            empty.set(sortedIds[i]);
            Slot workingSlot = this.originScopeSlots[sortedIds[i]];
            int dstId = i;
            do {
                boolean clickOnItemWithBundle;
                if (!empty.get(dstId) && ItemStack.isSameItemSameComponents((ItemStack)carriedStack, (ItemStack)this.originScopeStacks[dstId])) {
                    if (carriedStack.getCount() == this.originScopeStacks[dstId].getCount()) {
                        done.set(dstId);
                        dstId = srcToDst[dstId];
                        continue;
                    }
                    if (carriedStack.getCount() < this.originScopeStacks[dstId].getCount()) {
                        Slot dstSlot = this.originScopeSlots[dstId];
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(dstSlot, 0, ClickType.PICKUP, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(dstSlot, 0, ClickType.PICKUP, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, ClickType.PICKUP, playSound));
                        ItemStack tmp = carriedStack;
                        carriedStack = this.originScopeStacks[dstId];
                        this.originScopeStacks[dstId] = tmp;
                        done.set(dstId);
                        dstId = srcToDst[dstId];
                        continue;
                    }
                }
                int mouseButton = 0;
                boolean clickOnBundleWithItem = this.originScopeStacks[dstId].is(Items.BUNDLE) && !carriedStack.isEmpty();
                boolean bl = clickOnItemWithBundle = carriedStack.is(Items.BUNDLE) && !this.originScopeStacks[dstId].isEmpty();
                if (Config.options().bundlesUseLeftClick && (clickOnBundleWithItem || clickOnItemWithBundle)) {
                    mouseButton = 1;
                }
                InteractionManager.push(this.screenHelper.createClickEvent(this.originScopeSlots[dstId], mouseButton, ClickType.PICKUP, playSound));
                ItemStack tmp = carriedStack;
                carriedStack = this.originScopeStacks[dstId];
                this.originScopeStacks[dstId] = tmp;
                done.set(dstId);
                if (empty.get(dstId)) continue block2;
                dstId = srcToDst[dstId];
            } while (!done.get(dstId));
        }
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation SORT", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void fillStacks() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation STACK_FILL: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation STACK_FILL: other scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation STACK_FILL", new Object[0]);
        }
        this.raiseFlag();
        boolean playSound = SoundManager.shouldPlayOtherSounds();
        if (playSound) {
            SoundManager.resetForCount(SoundManager.estimateStackFillSounds(this.originScopeStacks, this.otherScopeStacks));
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            Slot srcSlot = this.originScopeSlots[i];
            ItemStack srcStack = this.originScopeStacks[i];
            if (srcStack.isEmpty()) continue;
            clickEvents.add(this.screenHelper.createClickEvent(srcSlot, 0, ClickType.PICKUP, false));
            for (int j = 0; j < this.otherScopeSlots.length; ++j) {
                Slot dstSlot = this.otherScopeSlots[j];
                ItemStack dstStack = this.otherScopeStacks[j];
                if (dstStack.isEmpty() || dstStack.getCount() >= dstSlot.getMaxStackSize(dstStack) || !ItemStack.isSameItemSameComponents((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                int delta = dstSlot.getMaxStackSize(dstStack) - dstStack.getCount();
                delta = Math.min(delta, srcStack.getCount());
                srcStack.setCount(srcStack.getCount() - delta);
                dstStack.setCount(dstStack.getCount() + delta);
                clickEvents.add(this.screenHelper.createClickEvent(dstSlot, 0, ClickType.PICKUP, playSound));
                if (srcStack.getCount() <= 0) break;
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.getCount() > 0) {
                    InteractionManager.push(this.screenHelper.createClickEvent(srcSlot, 0, ClickType.PICKUP, false));
                } else {
                    this.originScopeStacks[i] = ItemStack.EMPTY;
                }
            }
            clickEvents.clear();
        }
        this.lowerFlag();
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation STACK_FILL", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }

    @Override
    protected void transfer() {
        if (this.originScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation TRANSFER: origin scope is empty!", new Object[0]);
            }
            return;
        }
        if (this.otherScopeSlots.length == 0) {
            if (ClientSort.debug()) {
                ClientSort.LOG.warn("Cannot perform operation TRANSFER: other scope is empty!", new Object[0]);
            }
            return;
        }
        if (ClientSort.debug()) {
            ClientSort.LOG.info("Starting operation TRANSFER", new Object[0]);
        }
        this.raiseFlag();
        boolean playSound = SoundManager.shouldPlayOtherSounds();
        if (playSound) {
            SoundManager.resetForCount(SoundManager.estimateTransferSounds(this.originScopeStacks, this.otherScopeStacks));
        }
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.originScopeSlots.length - 1; i >= 0; --i) {
            Slot srcSlot = this.originScopeSlots[i];
            ItemStack srcStack = this.originScopeStacks[i];
            if (srcStack.isEmpty()) continue;
            clickEvents.add(this.screenHelper.createClickEvent(srcSlot, 0, ClickType.PICKUP, false));
            int emptySlotId = -1;
            for (int j = 0; j < this.otherScopeSlots.length; ++j) {
                Slot dstSlot = this.otherScopeSlots[j];
                ItemStack dstStack = this.otherScopeStacks[j];
                if (dstStack.isEmpty()) {
                    if (emptySlotId != -1) continue;
                    emptySlotId = j;
                    continue;
                }
                if (dstStack.getCount() >= dstSlot.getMaxStackSize(dstStack) || !ItemStack.isSameItemSameComponents((ItemStack)srcStack, (ItemStack)dstStack)) continue;
                int delta = dstSlot.getMaxStackSize(dstStack) - dstStack.getCount();
                delta = Math.min(delta, srcStack.getCount());
                srcStack.setCount(srcStack.getCount() - delta);
                dstStack.setCount(dstStack.getCount() + delta);
                clickEvents.add(this.screenHelper.createClickEvent(dstSlot, 0, ClickType.PICKUP, playSound));
                if (srcStack.isEmpty()) break;
            }
            if (!srcStack.isEmpty() && emptySlotId != -1) {
                Slot dstSlot = this.otherScopeSlots[emptySlotId];
                this.otherScopeStacks[emptySlotId] = srcStack.copy();
                srcStack.setCount(0);
                clickEvents.add(this.screenHelper.createClickEvent(dstSlot, 0, ClickType.PICKUP, playSound));
            }
            if (clickEvents.size() > 1) {
                InteractionManager.pushAll(clickEvents);
                InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
                clickEvents.clear();
                if (srcStack.getCount() > 0) {
                    InteractionManager.push(this.screenHelper.createClickEvent(srcSlot, 0, ClickType.PICKUP, false));
                } else {
                    this.originScopeStacks[i] = ItemStack.EMPTY;
                }
            }
            clickEvents.clear();
        }
        this.lowerFlag();
        if (ClientSort.debug()) {
            InteractionManager.push(() -> {
                ClientSort.LOG.info("Finished operation TRANSFER", new Object[0]);
                return InteractionManager.TICK_WAITER;
            });
        }
    }
}

